/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui.config.controller;

import frc.emul.config.Configuration;
import frc.emul.config.data.CfgItemController;
import frc.emul.config.data.CfgItemCurve;
import frc.emul.config.data.CfgItemSensitivity;
import frc.emul.util.swing.AALabel;
import frc.emul.vectrex.ui.Borders;
import frc.emul.vectrex.ui.config.UIUtils;
import frc.emul.vectrex.ui.config.controller.UIJInputCalibration;
import frc.input.JInputComponent;
import frc.input.JInputController;
import frc.input.JInputDetector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.java.games.input.Component;

public class UIJInputSettings {
    private CfgItemSensitivity editedSensitivity;
    private CfgItemCurve editedResponse;
    private volatile boolean canceled;

    public void configChanged() {
    }

    public final synchronized CfgItemController editControllerSettings(Window window, JInputController jInputController, Configuration configuration) {
        final JDialog jDialog = UIUtils.createDialog(window, "ParaJVE - Controller Settings", true);
        CfgItemController cfgItemController = configuration.getController(jInputController.getID());
        if (cfgItemController == null) {
            cfgItemController = jInputController.getDefaults();
        }
        this.editedSensitivity = new CfgItemSensitivity(cfgItemController.sensitivity);
        this.editedResponse = new CfgItemCurve(cfgItemController.response);
        final IEditablePanel iEditablePanel = this.buildControlsPane(jInputController, cfgItemController);
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 0));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 0, 10, 10));
        JButton jButton = new JButton(" OK ");
        final JButton jButton2 = new JButton(" Cancel ");
        jPanel.add(jPanel2);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        final CfgItemController cfgItemController2 = cfgItemController;
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!iEditablePanel.canValidate()) {
                    JOptionPane.showMessageDialog(iEditablePanel.getComponent(), "This configuration is invalid, and cannot be used!", "ParaJVE - Invalid Settings", 1);
                } else {
                    iEditablePanel.validate(cfgItemController2);
                    UIJInputSettings.this.canceled = false;
                    jButton2.doClick(0);
                }
            }
        });
        UIUtils.registerEscapeButton(jButton2, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jDialog.setDefaultCloseOperation(2);
        JPanel jPanel3 = new JPanel(new BorderLayout(10, 10));
        jPanel3.add((Component)iEditablePanel.getComponent(), "Center");
        jPanel3.add((Component)jPanel, "South");
        jDialog.getContentPane().add(jPanel3);
        UIUtils.setContainerBorder(jDialog.getContentPane());
        jDialog.pack();
        UIUtils.center(jDialog, jDialog.getOwner(), 0, 0);
        jDialog.getRootPane().setDefaultButton(jButton);
        jDialog.setResizable(false);
        this.canceled = true;
        jDialog.setVisible(true);
        if (this.canceled) {
            return null;
        }
        configuration.addController(cfgItemController);
        return cfgItemController;
    }

    private final IEditablePanel buildControlsPane(JInputController jInputController, CfgItemController cfgItemController) {
        final JPanel jPanel = new JPanel(new SpringLayout());
        final IEditablePanel iEditablePanel = this.buildJoyButtonsPane(jInputController, cfgItemController);
        final IEditablePanel iEditablePanel2 = this.buildJoyDirsPane(jInputController, cfgItemController);
        IEditablePanel iEditablePanel3 = new IEditablePanel(){

            public boolean canValidate() {
                return iEditablePanel.canValidate() && iEditablePanel2.canValidate();
            }

            public JComponent getComponent() {
                return jPanel;
            }

            public void validate(CfgItemController cfgItemController) {
                iEditablePanel.validate(cfgItemController);
                iEditablePanel2.validate(cfgItemController);
                cfgItemController.sensitivity = UIJInputSettings.this.editedSensitivity;
                cfgItemController.response = UIJInputSettings.this.editedResponse;
            }
        };
        JComponent jComponent = this.buildControllerPane(jInputController, iEditablePanel3);
        jPanel.add(jComponent);
        jPanel.add(iEditablePanel.getComponent());
        jPanel.add(iEditablePanel2.getComponent());
        UIUtils.makeCompactGrid(jPanel, 3, 1, 0, 0, 10, 10);
        return iEditablePanel3;
    }

    private final JComponent buildControllerPane(final JInputController jInputController, final IEditablePanel iEditablePanel) {
        AALabel aALabel = new AALabel(jInputController.getName());
        aALabel.setHorizontalAlignment(0);
        aALabel.setBorder(new CompoundBorder(Borders.ETCHED, new EmptyBorder(1, 4, 1, 4)));
        final JButton jButton = new JButton(" Test & Calibrate... ");
        final JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.add((Component)aALabel, "Center");
        jPanel.add((Component)jButton, "East");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CfgItemController cfgItemController = new CfgItemController(jInputController.getID());
                String string = null;
                String string2 = null;
                int n = 1;
                if (!iEditablePanel.canValidate()) {
                    string2 = "ParaJVE - Invalid Settings";
                    string = "This configuration is invalid, and cannot be tested!";
                } else if (!UIJInputCalibration.preloadImages()) {
                    string2 = "ParaJVE - Internal Error";
                    string = "Internal Error : Failed to load the tester images.";
                    n = 0;
                }
                if (string2 != null) {
                    JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(jPanel), string, string2, n);
                    return;
                }
                iEditablePanel.validate(cfgItemController);
                UIJInputCalibration uIJInputCalibration = new UIJInputCalibration();
                uIJInputCalibration.calibrate(SwingUtilities.getWindowAncestor(jButton), jInputController, cfgItemController);
            }
        });
        return jPanel;
    }

    private final IEditablePanel buildJoyDirsPane(JInputController jInputController, CfgItemController cfgItemController) {
        final JComboBox<String> jComboBox = new JComboBox<String>(new String[]{" Axis & Sliders", " PoV Buttons", " Digital Buttons"});
        final IEditablePanel[] iEditablePanelArray = new IEditablePanel[]{this.buildJoyDirsPaneAxis(jInputController, cfgItemController), this.buildJoyDirsPanePov(jInputController, cfgItemController), this.buildJoyDirsPaneBtns(jInputController, cfgItemController)};
        final JComponent[] jComponentArray = new JComponent[]{iEditablePanelArray[0].getComponent(), iEditablePanelArray[1].getComponent(), iEditablePanelArray[2].getComponent()};
        final JPanel jPanel = new JPanel(new BorderLayout(0, 0)){

            public Dimension getPreferredSize() {
                int n = 0;
                int n2 = 0;
                int n3 = jComponentArray.length;
                while (n3-- > 0) {
                    Dimension dimension = jComponentArray[n3].getPreferredSize();
                    if (dimension.width > n) {
                        n = dimension.width;
                    }
                    if (dimension.height <= n2) continue;
                    n2 = dimension.height;
                }
                return new Dimension(n, n2);
            }
        };
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        jComboBox.setSelectedIndex(-1);
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = jComboBox.getSelectedIndex();
                jPanel.removeAll();
                jPanel.add((Component)jComponentArray[n], "North");
                jPanel.invalidate();
                jPanel.validate();
                jPanel.repaint();
            }
        });
        switch (cfgItemController.dirMode) {
            case BTNS: {
                jComboBox.setSelectedIndex(2);
                break;
            }
            case POV: {
                jComboBox.setSelectedIndex(1);
                break;
            }
            default: {
                jComboBox.setSelectedIndex(0);
            }
        }
        jPanel2.add(jComboBox, "North");
        jPanel2.add((Component)jPanel, "Center");
        final JComponent jComponent = UIJInputSettings.makeTitledPanel(" DIRECTIONS", jPanel2);
        return new IEditablePanel(){

            public void validate(CfgItemController cfgItemController) {
                iEditablePanelArray[jComboBox.getSelectedIndex()].validate(cfgItemController);
            }

            public boolean canValidate() {
                return iEditablePanelArray[jComboBox.getSelectedIndex()].canValidate();
            }

            public JComponent getComponent() {
                return jComponent;
            }
        };
    }

    private final IEditablePanel buildJoyDirsPaneAxis(JInputController jInputController, CfgItemController cfgItemController) {
        final JPanel jPanel = new JPanel(new SpringLayout());
        Object[] objectArray = jInputController.getAnalogAxis().toArray();
        final JCheckBox[] jCheckBoxArray = new JCheckBox[2];
        final JComboBox[] jComboBoxArray = new JComboBox[2];
        int n = 0;
        while (n < 2) {
            JInputComponent jInputComponent;
            boolean bl = n == 0;
            String string = String.valueOf(bl ? "X" : "Y") + " Axis";
            JCheckBox jCheckBox = new JCheckBox("Inverted", bl ? cfgItemController.invertX : cfgItemController.invertY);
            JComboBox<Object> jComboBox = new JComboBox<Object>(new DefaultComboBoxModel<Object>(objectArray));
            jCheckBoxArray[n] = jCheckBox;
            jComboBoxArray[n] = jComboBox;
            jPanel.add(this.buildDetectButton(jInputController, jComboBox, string));
            jPanel.add(jCheckBox);
            jPanel.add(jComboBox);
            if (objectArray.length == 0) {
                jComboBox.setEnabled(false);
                jCheckBox.setEnabled(false);
            }
            if ((jInputComponent = jInputController.getComponent(bl ? cfgItemController.axisXID : cfgItemController.axisYID)) != null) {
                jComboBox.setSelectedItem(jInputComponent);
            }
            ++n;
        }
        UIUtils.makeCompactGrid(jPanel, 2, 3, 0, 0, 6, 4);
        return new IEditablePanel(){

            public JComponent getComponent() {
                return jPanel;
            }

            public boolean canValidate() {
                return jComboBoxArray[0].getSelectedItem() != null && jComboBoxArray[1].getSelectedItem() != null;
            }

            public void validate(CfgItemController cfgItemController) {
                cfgItemController.axisXID = ((JInputComponent)jComboBoxArray[0].getSelectedItem()).getID();
                cfgItemController.axisYID = ((JInputComponent)jComboBoxArray[1].getSelectedItem()).getID();
                cfgItemController.invertX = jCheckBoxArray[0].isSelected();
                cfgItemController.invertY = jCheckBoxArray[1].isSelected();
                cfgItemController.dirMode = CfgItemController.DirControl.AXIS;
            }
        };
    }

    private final IEditablePanel buildJoyDirsPanePov(JInputController jInputController, CfgItemController cfgItemController) {
        JInputComponent jInputComponent;
        final JPanel jPanel = new JPanel(new SpringLayout());
        Object[] objectArray = jInputController.getDigitalAxis().toArray();
        final JComboBox<Object> jComboBox = new JComboBox<Object>(new DefaultComboBoxModel<Object>(objectArray));
        jPanel.add(this.buildDetectButton(jInputController, jComboBox, "PoV Control"));
        jPanel.add(jComboBox);
        if (objectArray.length == 0) {
            jComboBox.setEnabled(false);
        }
        if ((jInputComponent = jInputController.getComponent(cfgItemController.povID)) != null) {
            jComboBox.setSelectedItem(jInputComponent);
        }
        UIUtils.makeCompactGrid(jPanel, 1, 2, 0, 0, 6, 4);
        return new IEditablePanel(){

            public JComponent getComponent() {
                return jPanel;
            }

            public boolean canValidate() {
                return jComboBox.getSelectedItem() != null;
            }

            public void validate(CfgItemController cfgItemController) {
                cfgItemController.povID = ((JInputComponent)jComboBox.getSelectedItem()).getID();
                cfgItemController.dirMode = CfgItemController.DirControl.POV;
            }
        };
    }

    private final IEditablePanel buildJoyDirsPaneBtns(JInputController jInputController, CfgItemController cfgItemController) {
        final JPanel jPanel = new JPanel(new SpringLayout());
        Object[] objectArray = jInputController.getButtons().toArray();
        String[] stringArray = new String[]{"Left", "Right", "Up", "Down"};
        String[] stringArray2 = cfgItemController.getDirectionButtonIDs();
        final JComboBox[] jComboBoxArray = new JComboBox[4];
        int n = 0;
        while (n < 4) {
            JInputComponent jInputComponent;
            JComboBox<Object> jComboBox;
            jComboBoxArray[n] = jComboBox = new JComboBox<Object>(new DefaultComboBoxModel<Object>(objectArray));
            jPanel.add(this.buildDetectButton(jInputController, jComboBox, stringArray[n]));
            jPanel.add(jComboBox);
            if (objectArray.length == 0) {
                jComboBox.setEnabled(false);
            }
            if ((jInputComponent = jInputController.getComponent(stringArray2[n])) != null) {
                jComboBox.setSelectedItem(jInputComponent);
            }
            ++n;
        }
        UIUtils.makeCompactGrid(jPanel, 4, 2, 0, 0, 6, 4);
        return new IEditablePanel(){

            public JComponent getComponent() {
                return jPanel;
            }

            public boolean canValidate() {
                int n = 4;
                while (n-- > 0) {
                    if (jComboBoxArray[n].getSelectedItem() != null) continue;
                    return false;
                }
                return true;
            }

            public void validate(CfgItemController cfgItemController) {
                String[] stringArray = new String[4];
                int n = 4;
                while (n-- > 0) {
                    stringArray[n] = ((JInputComponent)jComboBoxArray[n].getSelectedItem()).getID();
                }
                cfgItemController.setDirectionButtonIDs(stringArray);
                cfgItemController.dirMode = CfgItemController.DirControl.BTNS;
            }
        };
    }

    private final IEditablePanel buildJoyButtonsPane(JInputController jInputController, CfgItemController cfgItemController) {
        final JComboBox[] jComboBoxArray = new JComboBox[4];
        JPanel jPanel = new JPanel(new SpringLayout());
        Object[] objectArray = jInputController.getButtons().toArray();
        int n = 0;
        while (n < 4) {
            JComboBox<Object> jComboBox;
            jComboBoxArray[n] = jComboBox = new JComboBox<Object>(new DefaultComboBoxModel<Object>(objectArray));
            JInputComponent jInputComponent = jInputController.getComponent(cfgItemController.buttonID[n]);
            if (jInputComponent != null) {
                jComboBox.setSelectedItem(jInputComponent);
            }
            String string = "Button " + (n + 1);
            jPanel.add(this.buildDetectButton(jInputController, jComboBox, string));
            jPanel.add(jComboBox);
            jComboBox.setEnabled(objectArray.length > 0);
            ++n;
        }
        UIUtils.makeCompactGrid(jPanel, 4, 2, 0, 0, 6, 4);
        final JComponent jComponent = UIJInputSettings.makeTitledPanel(" BUTTONS", jPanel);
        return new IEditablePanel(){

            public JComponent getComponent() {
                return jComponent;
            }

            public boolean canValidate() {
                int n = 4;
                while (n-- > 0) {
                    if (jComboBoxArray[n].getSelectedItem() != null) continue;
                    return false;
                }
                return true;
            }

            public void validate(CfgItemController cfgItemController) {
                int n = 4;
                while (n-- > 0) {
                    cfgItemController.buttonID[n] = ((JInputComponent)jComboBoxArray[n].getSelectedItem()).getID();
                }
            }
        };
    }

    public static final JComponent makeTitledPanel(String string, JComponent jComponent) {
        return UIJInputSettings.makeTitledPanel(string, jComponent, Color.DARK_GRAY);
    }

    public static final JComponent makeTitledPanel(String string, JComponent jComponent, Color color) {
        if (string == null) {
            jComponent.setBorder(Borders.BEVEL_LOW_10);
            return jComponent;
        }
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        AALabel aALabel = new AALabel(" " + string);
        aALabel.setOpaque(true);
        aALabel.setFont(aALabel.getFont().deriveFont(3));
        aALabel.setBackground(color);
        aALabel.setForeground(Color.WHITE);
        aALabel.setBorder(Borders.BEVEL_RAISED);
        jPanel.add((Component)aALabel, "North");
        jPanel.add((Component)jComponent, "Center");
        jPanel.setBorder(new CompoundBorder(Borders.BEVEL_LOW, new EmptyBorder(1, 1, 0, 1)));
        jComponent.setBorder(new EmptyBorder(10, 9, 10, 9));
        return jPanel;
    }

    private JComponent buildDetectButton(final JInputController jInputController, final JComboBox jComboBox, final String string) {
        ComboBoxModel comboBoxModel = jComboBox.getModel();
        final JInputComponent[] jInputComponentArray = new JInputComponent[comboBoxModel.getSize()];
        final JButton jButton = new JButton(string);
        jButton.setToolTipText("Click this button to start the detection of \"" + string + "\".");
        if (jInputComponentArray.length == 0) {
            jButton.setEnabled(false);
            return jButton;
        }
        int n = jInputComponentArray.length;
        while (n-- > 0) {
            jInputComponentArray[n] = (JInputComponent)comboBoxModel.getElementAt(n);
        }
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!JInputDetector.check(jButton, jInputController)) {
                    return;
                }
                final boolean bl = jInputComponentArray[0].getType() instanceof Component.Identifier.Axis;
                final boolean bl2 = jInputComponentArray[0].getType().equals(Component.Identifier.Axis.POV);
                String string3 = bl2 ? "Hat Switch" : (bl ? "Axis" : "Button");
                JDialog jDialog = (JDialog)SwingUtilities.getWindowAncestor(jButton);
                final JDialog jDialog2 = new JDialog(jDialog, "ParaJVE - Detect " + string3 + "...", true);
                Container container = jDialog2.getContentPane();
                UIUtils.setContainerBorder(container);
                container.setLayout(new GridLayout(0, 1));
                jDialog2.setDefaultCloseOperation(2);
                String string2 = bl2 ? "Move the controller's new Hat Switch for :" : (bl ? "Move the controller along the new axis for :" : "Press the controller's new button for :");
                AALabel aALabel = new AALabel("<html><center>" + string2 + "<br><font size=+1>" + string + "</font><br><br><br>(click in this dialog or press ESCAPE to cancel)");
                aALabel.setHorizontalAlignment(0);
                container.add(aALabel);
                aALabel.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        jDialog2.dispose();
                    }
                });
                jDialog2.addKeyListener(new KeyAdapter(){

                    public void keyReleased(KeyEvent keyEvent) {
                        if (keyEvent.getKeyCode() == 27) {
                            jDialog2.dispose();
                        }
                    }
                });
                final JInputDetector jInputDetector = new JInputDetector();
                jDialog2.addWindowListener(new WindowAdapter(){

                    public void windowOpened(WindowEvent windowEvent) {
                        if (bl2 || !bl) {
                            jInputDetector.detectButton(jDialog2, jInputController, jInputComponentArray);
                        } else {
                            jInputDetector.detectAxis(jDialog2, jInputController, jInputComponentArray);
                        }
                    }

                    public void windowClosed(WindowEvent windowEvent) {
                        jDialog2.removeWindowListener(this);
                        JInputComponent jInputComponent = jInputDetector.getResult();
                        if (jInputComponent != null) {
                            jComboBox.setSelectedItem(jInputComponent);
                        }
                    }
                });
                jDialog2.setBounds(jDialog.getBounds());
                jDialog2.setResizable(false);
                jDialog2.setVisible(true);
            }
        });
        return jButton;
    }

    private static interface IEditablePanel {
        public JComponent getComponent();

        public boolean canValidate();

        public void validate(CfgItemController var1);
    }
}

